class AdultHP extends TournamentHealth;

#exec mesh import mesh=AdultHP anivfile=Models\AdultHP_a.3d datafile=Models\AdultHP_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=AdultHP x=0 y=0 z=0
#exec mesh sequence mesh=AdultHP seq=All startframe=0 numframes=1

#exec meshmap new meshmap=AdultHP mesh=AdultHP
#exec meshmap scale meshmap=AdultHP x=0.05078 y=0.05078 z=0.10156

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		local Pawn P;
			
		if ( ValidTouch(Other) ) 
		{	
			P = Pawn(Other);	
			if (P.Health < 500) 
			{
				P.Health += HealingAmount;
				if (P.Health > 500)
					{
					P.Health = 500;
					}
				PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
			}
		}
	}
}

defaultproperties
{
     HealingAmount=200
     bSuperHeal=True
     PickupMessage="You picked up the LoveDoll +"
     ItemName="Healthy LoveDoll"
     RespawnTime=30.000000
     PickupViewMesh=Mesh'AdultHP'
     PickupSound=Sound'Botpack.Pickups.UTSuperHeal'
     Mesh=Mesh'AdultHP'
     ScaleGlow=2.000000
     CollisionRadius=25
     CollisionHeight=13
     MultiSkins(0)=Texture'BotPack.ShaneFx.top2'
     MultiSkins(1)=Texture'AdultHP'
     bRotatingPickup=True
     bFixedRotationDir=True
     RotationRate=(Yaw=8192)
     DesiredRotation=(Yaw=30000)
}
